IF OBJECT_ID('P_EXP_CTB_MOV_VENDAS_CONTABIL') IS NOT NULL
    BEGIN
        DROP PROCEDURE P_EXP_CTB_MOV_VENDAS_CONTABIL;
    END;
GO

CREATE PROCEDURE P_EXP_CTB_MOV_VENDAS_CONTABIL(@CD_EMP      INT,
                                               @CD_FILIAL   INT,
                                               @DT_INI      DATETIME,
                                               @DT_FIM      DATETIME,
                                               @FLAG_LIMPAR INT      = 0)
WITH ENCRYPTION
AS
    BEGIN TRY
        BEGIN
            DECLARE @RS_CD_EMP INT;
            DECLARE @RS_CD_FILIAL INT;
            DECLARE @RS_DT_MOV DATETIME;
            DECLARE @RS_VLR_DINH_LIQ MONEY;
            DECLARE @RS_VLR_CHQ_VISTA MONEY;
            DECLARE @RS_VLR_RECBTO_CREDIARIO_CHQ_VISTA MONEY;
            DECLARE @RS_VLR_DUP MONEY;
            DECLARE @RS_VLR_VALE_COMPRA MONEY;
            DECLARE @VLR_NCC_OUTRO_DIA MONEY;
            DECLARE @VLR_RECBTO_DINH_RECARGA MONEY;
			DECLARE @VLR_LINX_PROMO_N_FISCAL MONEY;
			DECLARE @VLR_LINX_PROMO_FISCAL MONEY;
			DECLARE @VLR_SUPER_TROCO_DINHEIRO MONEY;
		    DECLARE @NR_CONTROLE			VARCHAR (50)
		
	
            ------------------------------------------------------------------------------------------------------------------------------
            --CRIANDO A TABELA TEMPORARIA ##CTB_EXP_MOV
            ------------------------------------------------------------------------------------------------------------------------------
            EXEC P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV
                 @FLAG_LIMPAR;
            DECLARE RS_RESULT CURSOR
            FOR SELECT T.CD_EMP
                     , T.CD_FILIAL
                     , T.DT_MOV
                     , T.VLR_DINH_LIQ
                     , T.VLR_CHQ_VISTA
                     , T.VLR_RECBTO_CREDIARIO_CHQ_VISTA
                     , T.VLR_DUP + T.VLR_DEV_DUP AS VLR_DUP
                     , T.VLR_VALE_COMPRA
                     , T.VLR_NCC_OUTRO_DIA
                     , VLR_RECBTO_DINH_RECARGA
					 , VLR_LINX_PROMO_N_FISCAL 
					 , VLR_LINX_PROMO_FISCAL
					 , VLR_SUPER_TROCO_DINHEIRO
                 FROM UFD_EXP_CTB_MOV_CAIXA(@CD_EMP, @CD_FILIAL, @DT_INI, @DT_FIM) T	
			-- SELECT * FROM UFD_EXP_CTB_MOV_CAIXA(1, 10, '20250310', '20250310') T
                ORDER BY T.CD_EMP
                       , T.CD_FILIAL
                       , T.DT_MOV;

            --Abrindo cursor
            OPEN RS_RESULT;
		
            --Atribuindo valores do select nas variveis
            FETCH NEXT FROM RS_RESULT INTO @RS_CD_EMP, @RS_CD_FILIAL, @RS_DT_MOV, @RS_VLR_DINH_LIQ, @RS_VLR_CHQ_VISTA, 
			                               @RS_VLR_RECBTO_CREDIARIO_CHQ_VISTA, @RS_VLR_DUP, @RS_VLR_VALE_COMPRA, @VLR_NCC_OUTRO_DIA, 
										   @VLR_RECBTO_DINH_RECARGA,@VLR_LINX_PROMO_N_FISCAL,@VLR_LINX_PROMO_FISCAL, @VLR_SUPER_TROCO_DINHEIRO;		

            --Iniciando lao
            WHILE @@FETCH_STATUS = 0
                BEGIN

				--===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Nmero de Documento ===================
				
				--1 - vendas dinheiro, recargas no fiscal, cartao, convnio						  
				--2 - vendas icms
				--3 - vendas confins 
				--4 - vendas pis 
				--5 - vendas custo
				
								
				SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
								RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
								 RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
								  RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2) + '021'  -- 02 CD_MOVIMENTO 1 tipo de registro 
								  
			    --===========================================================================================================================


                    IF @RS_VLR_DINH_LIQ > 0
                        BEGIN
                            ------------------------------------------------------------------------------------------------------------------
                            --VENDAS DEBITO - Ctb_Cnt_Caixa
                            ------------------------------------------------------------------------------------------------------------------
																		      
						INSERT INTO ##CTB_EXP_MOV 

										  (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
										  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
										  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
										  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                   SELECT @RS_CD_EMP --CD_EMP
                                        , @CD_FILIAL --CD_FILIAL_EXPORT
                                        , @RS_CD_FILIAL --CD_FILIAL
                                        , 2 AS COD_MOVIMENTO --CODIGO MOVIMENTO
                                        , 'MOVIMENTO DE VENDAS' --MOVIMENTO								
                                        , '' --OPERACAO
                                        , 'VENDAS - DEBITO' --OPERACAO_DEBITO	
                                        , 0 --CD_CNT_RED_CREDITO
                                        , '' --CD_CNT_CREDITO
                                        , 0 --CD_CNT_RED_DEBITO
                                        , '' --CD_CNT_DEBITO										
                                        , @RS_DT_MOV --DT_MOV
                                        , 'VALOR REF. VENDAS: DINHEIRO' --HIST
                                        , @RS_VLR_DINH_LIQ + @VLR_NCC_OUTRO_DIA --VLR_LANC
                                        , 'D' --TP_TRANSA	
                                        , 0 --RATEIO_CENTRO_CUSTO
                                        , '' --DS_CENTRO_CUSTO
                                        , 0 --CNT_CENTRO_CUSTO
                                        , 0 --VLR_CENTRO_CUSTO											
                                        , 'FILIAIS' --ORIG_CONTA
                                        , 0 --COD_CONTA
                                        , OBJECT_NAME(@@PROCID) --NM_PROCEDURE
                                        , 'D' --TIPO_LANCTO
                                        , 0  --CD_EVENTO
								, 0  AS NR_DP
								, 0  AS ANO
								, @NR_CONTROLE AS NR_DOC
								, 0 AS CD_BC_LANC;

                        END;
                    IF @RS_VLR_VALE_COMPRA > 0
                        BEGIN
                            ----------------------------------------------------------------------------------------------------------------------
                            --VENDAS DEBITO - VLR_VALE_COMPRA- Ctb_Cnt_Caixa
                            ---------------------------------------------------------------------------------------------------------------------

                            INSERT INTO ##CTB_EXP_MOV 

						  (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
						  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
						  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
						  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                   SELECT @RS_CD_EMP --CD_EMP
                                        , @CD_FILIAL --CD_FILIAL_EXPORT
                                        , @RS_CD_FILIAL --CD_FILIAL
                                        , 2 AS COD_MOVIMENTO --CODIGO MOVIMENTO
                                        , 'MOVIMENTO DE VENDAS' --MOVIMENTO								
                                        , '' --OPERACAO
                                        , 'VENDAS - DEBITO' --OPERACAO_DEBITO	
                                        , 0 --CD_CNT_RED_CREDITO
                                        , '' --CD_CNT_CREDITO
                                        , 0 --CD_CNT_RED_DEBITO
                                        , '' --CD_CNT_DEBITO										
                                        , @RS_DT_MOV --DT_MOV
                                        , 'VALOR REF. VENDAS: VALE COMPRA' --HIST
                                        , @RS_VLR_VALE_COMPRA --VLR_LANC
                                        , 'D' --TP_TRANSA	
                                        , 0 --RATEIO_CENTRO_CUSTO
                                        , '' --DS_CENTRO_CUSTO
                                        , 0 --CNT_CENTRO_CUSTO
                                        , 0 --VLR_CENTRO_CUSTO											
                                        , 'FILIAIS' --ORIG_CONTA
                                        , 51 --COD_CONTA
                                        , OBJECT_NAME(@@PROCID) --NM_PROCEDURE
                                        , 'D' --TIPO_LANCTO
                                        , 0
								, 0  AS NR_DP
								, 0  AS ANO
								, @NR_CONTROLE AS NR_DOC
								, 0 AS CD_BC_LANC;                                                           --CD_EVENTO	

                        END;
                    IF @VLR_RECBTO_DINH_RECARGA > 0
                        BEGIN
                            ----------------------------------------------------------------------------------------------------------------------
                            --VENDAS DEBITO - RECARGA DINHEIRO - Ctb_Cnt_Caixa
                            ---------------------------------------------------------------------------------------------------------------------
					
					INSERT INTO ##CTB_EXP_MOV 

							 (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
							 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
							 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
							 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                   SELECT @RS_CD_EMP --CD_EMP
                                        , @CD_FILIAL --CD_FILIAL_EXPORT
                                        , @RS_CD_FILIAL --CD_FILIAL
                                        , 2 AS COD_MOVIMENTO --CODIGO MOVIMENTO
                                        , 'MOVIMENTO DE VENDAS' --MOVIMENTO								
                                        , '' --OPERACAO
                                        , 'VENDAS - RECARGA CELULAR - DEBITO' --OPERACAO_DEBITO	
                                        , 0 --CD_CNT_RED_CREDITO
                                        , '' --CD_CNT_CREDITO
                                        , 0 --CD_CNT_RED_DEBITO
                                        , '' --CD_CNT_DEBITO										
                                        , @RS_DT_MOV --DT_MOV
                                        , 'VALOR REF. VENDAS: RECARGA CELULAR - DINHEIRO' --HIST
                                        , @VLR_RECBTO_DINH_RECARGA --VLR_LANC
                                        , 'D' --TP_TRANSA	
                                        , 0 --RATEIO_CENTRO_CUSTO
                                        , '' --DS_CENTRO_CUSTO
                                        , 0 --CNT_CENTRO_CUSTO
                                        , 0 --VLR_CENTRO_CUSTO											
                                        , 'FILIAIS' --ORIG_CONTA
                                        , 0 --COD_CONTA
                                        , OBJECT_NAME(@@PROCID) --NM_PROCEDURE
                                        , 'D' --TIPO_LANCTO
                                        , 0
								, 0  AS NR_DP
								, 0  AS ANO
								, @NR_CONTROLE AS NR_DOC
								, 0 AS CD_BC_LANC;                                                           --CD_EVENTO	

                        END;
                    IF @RS_VLR_CHQ_VISTA > 0
                        BEGIN
                            ------------------------------------------------------------------------------------------------------------------
                            --VENDAS CHEQUE A VISTA - Ctb_Cnt_Cheques_Vista
                            ------------------------------------------------------------------------------------------------------------------

                            INSERT INTO ##CTB_EXP_MOV 

							 (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
							 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
							 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
							 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                   SELECT @RS_CD_EMP --CD_EMP
                                        , @CD_FILIAL --CD_FILIAL_EXPORT
                                        , @RS_CD_FILIAL --CD_FILIAL
                                        , 2 AS COD_MOVIMENTO --CODIGO MOVIMENTO
                                        , 'MOVIMENTO DE VENDAS' --MOVIMENTO								
                                        , '' --OPERACAO
                                        , 'VENDAS - DEBITO' --OPERACAO_DEBITO	
                                        , 0 --CD_CNT_RED_CREDITO
                                        , '' --CD_CNT_CREDITO
                                        , 0 --CD_CNT_RED_DEBITO
                                        , '' --CD_CNT_DEBITO										
                                        , @RS_DT_MOV --DT_MOV
                                        , 'VALOR REF. VENDAS: CHEQUE A VISTA' --HIST
                                        , @RS_VLR_CHQ_VISTA --VLR_LANC
                                        , 'D' --TP_TRANSA
                                        , 0 --RATEIO_CENTRO_CUSTO
                                        , '' --DS_CENTRO_CUSTO
                                        , 0 --CNT_CENTRO_CUSTO
                                        , 0 --VLR_CENTRO_CUSTO											
                                        , 'FILIAIS' --ORIG_CONTA
                                        , 3 --COD_CONTA
                                        , OBJECT_NAME(@@PROCID) --NM_PROCEDURE
                                        , 'D' --TIPO_LANCTO
                                        , 0
								, 0  AS NR_DP
								, 0  AS ANO
								, @NR_CONTROLE AS NR_DOC
								, 0 AS CD_BC_LANC;                                                           --CD_EVENTO

                        END;
                    IF @RS_VLR_RECBTO_CREDIARIO_CHQ_VISTA > 0
                        BEGIN
                            ------------------------------------------------------------------------------------------------------------------
                            --RECEBIMENTO COM CHEQUES A VISTA - Ctb_Cnt_Tranf_Dinheiro_Para_Matriz
                            ------------------------------------------------------------------------------------------------------------------

                           INSERT INTO ##CTB_EXP_MOV 

							 (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
							 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
							 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
							 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                   SELECT @RS_CD_EMP --CD_EMP
                                        , @CD_FILIAL --CD_FILIAL_EXPORT
                                        , @RS_CD_FILIAL --CD_FILIAL
                                        , 3 AS COD_MOVIMENTO --CODIGO MOVIMENTO
                                        , 'MOVIMENTO RECBTO CREDIARIO - CHEQUES' --MOVIMENTO								
                                        , '' --OPERACAO
                                        , 'CREDIARIO CHEQUE - DEBITO' --OPERACAO_DEBITO	
                                        , 0 --CD_CNT_RED_CREDITO
                                        , '' --CD_CNT_CREDITO
                                        , 0 --CD_CNT_RED_DEBITO
                                        , '' --CD_CNT_DEBITO										
                                        , @RS_DT_MOV --DT_MOV
                                        , 'VALOR REF. RECBTO CREDIARIO: CHEQUE A VISTA' --HIST
                                        , @RS_VLR_RECBTO_CREDIARIO_CHQ_VISTA --VLR_LANC
                                        , 'D' --TP_TRANSA	
                                        , 0 --RATEIO_CENTRO_CUSTO
                                        , '' --DS_CENTRO_CUSTO
                                        , 0 --CNT_CENTRO_CUSTO
                                        , 0 --VLR_CENTRO_CUSTO											
                                        , 'MATRIZ' --ORIG_CONTA
                                        , 14 --COD_CONTA
                                        , OBJECT_NAME(@@PROCID) --NM_PROCEDURE
                                        , 'D' --TIPO_LANCTO
                                        , 0
								, 0  AS NR_DP
								, 0  AS ANO
								, @NR_CONTROLE AS NR_DOC
								, 0 AS CD_BC_LANC;                                                           --CD_EVENTO
                            ------------------------------------------------------------------------------------------------------------------
                            --RECEBIMENTO COM CHEQUES A VISTA - Ctb_Cnt_Movimento_Recbto_Crediario_Chq_Vista
                            ------------------------------------------------------------------------------------------------------------------
					   										
                           INSERT INTO ##CTB_EXP_MOV 

						  (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
						  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
						  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
						  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                   SELECT @RS_CD_EMP --CD_EMP
                                        , @CD_FILIAL --CD_FILIAL_EXPORT
                                        , @RS_CD_FILIAL --CD_FILIAL
                                        , 3 AS COD_MOVIMENTO --CODIGO MOVIMENTO
                                        , 'MOVIMENTO RECBTO CREDIARIO - CHEQUES' --MOVIMENTO								
                                        , 'CREDIARIO CHEQUE - CREDITO' --OPERACAO
                                        , '' --OPERACAO_DEBITO																	
                                        , 0 --CD_CNT_RED_CREDITO
                                        , '' --CD_CNT_CREDITO
                                        , 0 --CD_CNT_RED_DEBITO
                                        , '' --CD_CNT_DEBITO										
                                        , @RS_DT_MOV --DT_MOV
                                        , 'VALOR REF. RECBTO CREDIARIO: CHEQUE A VISTA' --HIST
                                        , @RS_VLR_RECBTO_CREDIARIO_CHQ_VISTA --VLR_LANC
                                        , 'C' --TP_TRANSA	
                                        , 0 --RATEIO_CENTRO_CUSTO
                                        , '' --DS_CENTRO_CUSTO
                                        , 0 --CNT_CENTRO_CUSTO
                                        , 0 --VLR_CENTRO_CUSTO											
                                        , 'FILIAIS' --ORIG_CONTA
                                        , 44 --COD_CONTA
                                        , OBJECT_NAME(@@PROCID) --NM_PROCEDURE
                                        , 'D' --TIPO_LANCTO
                                        , 0
								, 0  AS NR_DP
								, 0  AS ANO
								, @NR_CONTROLE AS NR_DOC
								, 0 AS CD_BC_LANC;                                                          --CD_EVENTO										

                        END;
                    IF @RS_VLR_DUP > 0 

                        BEGIN
                            ------------------------------------------------------------------------------------------------------------------
                            --VENDAS DUPLICATAS - Ctb_Cnt_Duplicatas_Receber
                            ------------------------------------------------------------------------------------------------------------------

					   INSERT INTO ##CTB_EXP_MOV 

							 (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
							 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
							 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
							 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                   SELECT @RS_CD_EMP --CD_EMP
                                        , @CD_FILIAL --CD_FILIAL_EXPORT
                                        , @RS_CD_FILIAL --CD_FILIAL
                                        , 2 AS COD_MOVIMENTO --CODIGO MOVIMENTO
                                        , 'MOVIMENTO DE VENDAS' --MOVIMENTO								
                                        , '' --OPERACAO
                                        , 'VENDAS - DEBITO' --OPERACAO_DEBITO	
                                        , 0 --CD_CNT_RED_CREDITO
                                        , '' --CD_CNT_CREDITO
                                        , 0 --CD_CNT_RED_DEBITO
                                        , '' --CD_CNT_DEBITO										
                                        , @RS_DT_MOV --DT_MOV
                                        , 'VALOR REF. VENDAS: DUPLICATAS A RECEBER' --HIST
                                        , @RS_VLR_DUP   --VLR_LANC
                                        , 'D' --TP_TRANSA
                                        , 0 --RATEIO_CENTRO_CUSTO
                                        , '' --DS_CENTRO_CUSTO
                                        , 0 --CNT_CENTRO_CUSTO
                                        , 0 --VLR_CENTRO_CUSTO											
                                        , 'FILIAIS' --ORIG_CONTA
                                        , 4 --COD_CONTA
                                        , OBJECT_NAME(@@PROCID) --NM_PROCEDURE
                                        , 'D' --TIPO_LANCTO
                                        , 0
								, 0  AS NR_DP
								, 0  AS ANO
								, @NR_CONTROLE AS NR_DOC
								, 0 AS CD_BC_LANC;                                                           --CD_EVENTO	

                        END;
						
					--linx promo no fiscal 
					
					 IF @VLR_LINX_PROMO_N_FISCAL > 0
                        BEGIN
                            ------------------------------------------------------------------------------------------------------------------
                            --VENDAS DEBITO - Ctb_Cnt_Caixa
                            ------------------------------------------------------------------------------------------------------------------
																		      
						INSERT INTO ##CTB_EXP_MOV 

										  (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
										  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
										  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
										  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                   SELECT @RS_CD_EMP --CD_EMP
                                        , @CD_FILIAL --CD_FILIAL_EXPORT
                                        , @RS_CD_FILIAL --CD_FILIAL
                                        , 2 AS COD_MOVIMENTO --CODIGO MOVIMENTO
                                        , 'MOVIMENTO DE VENDAS' --MOVIMENTO								
                                        , '' --OPERACAO
                                        , 'VENDAS LINX PROMO - DEBITO ' --OPERACAO_DEBITO	
                                        , 0 --CD_CNT_RED_CREDITO
                                        , '' --CD_CNT_CREDITO
                                        , 0 --CD_CNT_RED_DEBITO
                                        , '' --CD_CNT_DEBITO										
                                        , @RS_DT_MOV --DT_MOV
                                        , 'VALOR REF. VENDAS: VALE PRESENTE LINX PROMO' --HIST
                                        , @VLR_LINX_PROMO_N_FISCAL --VLR_LANC
                                        , 'D' --TP_TRANSA	
                                        , 0 --RATEIO_CENTRO_CUSTO
                                        , '' --DS_CENTRO_CUSTO
                                        , 0 --CNT_CENTRO_CUSTO
                                        , 0 --VLR_CENTRO_CUSTO											
                                        , 'FILIAIS' --ORIG_CONTA
                                        , 56 --COD_CONTA
                                        , OBJECT_NAME(@@PROCID) --NM_PROCEDURE
                                        , 'D' --TIPO_LANCTO
                                        , 0  --CD_EVENTO
								, 0  AS NR_DP
								, 0  AS ANO
								, @NR_CONTROLE AS NR_DOC
								, 0 AS CD_BC_LANC;

                        END;
					--- Fim linx promo no fiscal 
					
					
					
					--linx promo fiscal 
					IF @VLR_LINX_PROMO_FISCAL > 0
                        BEGIN
                            ------------------------------------------------------------------------------------------------------------------
                            --VENDAS DEBITO - Ctb_Cnt_Caixa
                            ------------------------------------------------------------------------------------------------------------------
																		      
						INSERT INTO ##CTB_EXP_MOV 

										  (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
										  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
										  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
										  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                   SELECT @RS_CD_EMP --CD_EMP
                                        , @CD_FILIAL --CD_FILIAL_EXPORT
                                        , @RS_CD_FILIAL --CD_FILIAL
                                        , 2 AS COD_MOVIMENTO --CODIGO MOVIMENTO
                                        , 'MOVIMENTO DE VENDAS' --MOVIMENTO								
                                        , '' --OPERACAO
                                        , 'VENDAS - DEBITO ' --OPERACAO_DEBITO	
                                        , 0 --CD_CNT_RED_CREDITO
                                        , '' --CD_CNT_CREDITO
                                        , 0 --CD_CNT_RED_DEBITO
                                        , '' --CD_CNT_DEBITO										
                                        , @RS_DT_MOV --DT_MOV
                                        , 'VALOR REF. VENDAS: PGTO COM LINX PROMO' --HIST
                                        , @VLR_LINX_PROMO_FISCAL --VLR_LANC
                                        , 'D' --TP_TRANSA	
                                        , 0 --RATEIO_CENTRO_CUSTO
                                        , '' --DS_CENTRO_CUSTO
                                        , 0 --CNT_CENTRO_CUSTO
                                        , 0 --VLR_CENTRO_CUSTO											
                                        , 'FILIAIS' --ORIG_CONTA
                                        , 56 --COD_CONTA
                                        , OBJECT_NAME(@@PROCID) --NM_PROCEDURE
                                        , 'D' --TIPO_LANCTO
                                        , 0  --CD_EVENTO
								, 0  AS NR_DP
								, 0  AS ANO
								, @NR_CONTROLE AS NR_DOC
								, 0 AS CD_BC_LANC;

                        END;

					--- Fim linx promo fiscal

                    -- super troco dinheiro
					IF @VLR_SUPER_TROCO_DINHEIRO > 0
                        BEGIN
                            ------------------------------------------------------------------------------------------------------------------
                            --VENDAS DEBITO - Ctb_Cnt_Caixa
                            ------------------------------------------------------------------------------------------------------------------
																		      
						INSERT INTO ##CTB_EXP_MOV 

										  (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
										  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
										  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
										  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                   SELECT @RS_CD_EMP --CD_EMP
                                        , @CD_FILIAL --CD_FILIAL_EXPORT
                                        , @RS_CD_FILIAL --CD_FILIAL
                                        , 2 AS COD_MOVIMENTO --CODIGO MOVIMENTO
                                        , 'MOVIMENTO DE VENDAS' --MOVIMENTO								
                                        , '' --OPERACAO
                                        , 'VENDAS SUPER TROCO - DEBITO ' --OPERACAO_DEBITO	
                                        , 0 --CD_CNT_RED_CREDITO
                                        , '' --CD_CNT_CREDITO
                                        , 0 --CD_CNT_RED_DEBITO
                                        , '' --CD_CNT_DEBITO										
                                        , @RS_DT_MOV --DT_MOV
                                        , 'VALOR REF. SUPER TROCO DINHEIRO' --HIST
                                        , @VLR_SUPER_TROCO_DINHEIRO --VLR_LANC
                                        , 'D' --TP_TRANSA	
                                        , 0 --RATEIO_CENTRO_CUSTO
                                        , '' --DS_CENTRO_CUSTO
                                        , 0 --CNT_CENTRO_CUSTO
                                        , 0 --VLR_CENTRO_CUSTO											
                                        , 'FILIAIS' --ORIG_CONTA
                                        , 0 --COD_CONTA
                                        , OBJECT_NAME(@@PROCID) --NM_PROCEDURE
                                        , 'D' --TIPO_LANCTO
                                        , 0  --CD_EVENTO
								, 0  AS NR_DP
								, 0  AS ANO
								, @NR_CONTROLE AS NR_DOC
								, 0 AS CD_BC_LANC;

                        END;

					--- Fim super troco dinh

														 					
								 
                    --Prximo registro				
                    FETCH NEXT FROM RS_RESULT INTO @RS_CD_EMP, @RS_CD_FILIAL, @RS_DT_MOV, @RS_VLR_DINH_LIQ, @RS_VLR_CHQ_VISTA, 
					                               @RS_VLR_RECBTO_CREDIARIO_CHQ_VISTA, @RS_VLR_DUP, @RS_VLR_VALE_COMPRA, 
												   @VLR_NCC_OUTRO_DIA, @VLR_RECBTO_DINH_RECARGA,@VLR_LINX_PROMO_N_FISCAL,@VLR_LINX_PROMO_FISCAL,@VLR_SUPER_TROCO_DINHEIRO;
                END;
            CLOSE RS_RESULT;
            DEALLOCATE RS_RESULT;
        END;
    END TRY
    BEGIN CATCH
        CLOSE RS_RESULT;
        DEALLOCATE RS_RESULT;
        INSERT INTO ADM_ERRO
        (numero
       , severidade
       , estado
       , rotina
       , linha
       , mensagem
       , dtErro
        )
               SELECT ERROR_NUMBER() AS numero
                    , ERROR_SEVERITY() AS severidade
                    , ERROR_STATE() AS estado
                    , ERROR_PROCEDURE() AS rotina
                    , ERROR_LINE() AS linha
                    , ERROR_MESSAGE() AS mensagem
                    , GETDATE() AS dtErro;
    END CATCH;